/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.evolvedmekanism.client.renderers.datas;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import fr.iglee42.evolvedmekanism.client.CustomModelRenderer;
import fr.iglee42.evolvedmekanism.client.renderers.datas.CustomRenderData;
import fr.iglee42.evolvedmekanism.multiblock.apt.APTMultiblockData;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.ModelRenderer;
import mekanism.client.render.RenderResizableCuboid;
import mekanism.common.lib.multiblock.MultiblockData;
import net.minecraft.client.Camera;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class MultipleCustomRenderData {
    private static final Map<String, MekanismRenderer.Model3D> cachedModels = new Object2ObjectOpenHashMap();
    private final Map<String, CustomRenderData> datas = new HashMap<String, CustomRenderData>();
    private final Map<String, Set<Direction>> ignoredFaces = new Object2ObjectOpenHashMap();
    private final Map<String, Function<MekanismRenderer.Model3D, MekanismRenderer.Model3D>> customFunc = new Object2ObjectOpenHashMap();

    public Map<String, CustomRenderData> getDatas() {
        return this.datas;
    }

    public String add(String id, CustomRenderData data, Direction ... ignoredFaces) {
        this.datas.put(id, data);
        this.ignoredFaces.put(id, Set.of(ignoredFaces));
        return id;
    }

    public void setCustomFunc(String data, Function<MekanismRenderer.Model3D, MekanismRenderer.Model3D> axis) {
        this.customFunc.put(data, axis);
    }

    public void renderAllDatas(Camera camera, BlockPos rendererPos, PoseStack matrix, VertexConsumer buffer, int overlay, float scale, MultiblockData multiblock) {
        this.datas.forEach((id, data) -> {
            MekanismRenderer.Model3D gasModel = cachedModels.computeIfAbsent((String)id, d -> {
                MekanismRenderer.Model3D model = CustomModelRenderer.getModel(data, 1.0).copy().setSideRender(dir -> !((Set)this.ignoredFaces.getOrDefault(id, new HashSet())).contains(dir));
                model = this.customFunc.getOrDefault(id, m -> m).apply(model);
                return model;
            });
            if (multiblock instanceof APTMultiblockData) {
                APTMultiblockData apt = (APTMultiblockData)multiblock;
                gasModel = gasModel.bounds(gasModel.minX, gasModel.minY, gasModel.minZ, gasModel.maxX, (float)(apt.height() - 2) * apt.prevGasScale, gasModel.maxZ);
            }
            this.renderObject(camera, (CustomRenderData)data, rendererPos, gasModel, matrix, buffer, overlay, scale);
        });
    }

    private void renderObject(Camera camera, CustomRenderData data, BlockPos rendererPos, MekanismRenderer.Model3D object, @NotNull PoseStack matrix, VertexConsumer buffer, int overlay, float scale) {
        int glow = data.calculateGlowLight(0xF00000);
        matrix.m_85836_();
        matrix.m_252880_((float)(data.location.m_123341_() - rendererPos.m_123341_()), (float)(data.location.m_123342_() - rendererPos.m_123342_()), (float)(data.location.m_123343_() - rendererPos.m_123343_()));
        MekanismRenderer.renderObject((MekanismRenderer.Model3D)object, (PoseStack)matrix, (VertexConsumer)buffer, (int)data.getColorARGB(scale), (int)glow, (int)overlay, (RenderResizableCuboid.FaceDisplay)this.getCustomFaceDisplay(camera, data, object), (Camera)camera, (BlockPos)data.location);
        matrix.m_85849_();
    }

    private RenderResizableCuboid.FaceDisplay getCustomFaceDisplay(Camera camera, CustomRenderData data, MekanismRenderer.Model3D model) {
        return this.isInsideBounds(camera, data.location.m_123341_(), data.location.m_123342_(), data.location.m_123343_(), (float)data.location.m_123341_() + data.length, (float)data.location.m_123342_() + ModelRenderer.getActualHeight((MekanismRenderer.Model3D)model), (float)data.location.m_123343_() + data.width) ? RenderResizableCuboid.FaceDisplay.BACK : RenderResizableCuboid.FaceDisplay.FRONT;
    }

    private boolean isInsideBounds(Camera camera, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        Vec3 projectedView = camera.m_90583_();
        return minX <= projectedView.f_82479_ && projectedView.f_82479_ <= maxX && minY <= projectedView.f_82480_ && projectedView.f_82480_ <= maxY && minZ <= projectedView.f_82481_ && projectedView.f_82481_ <= maxZ;
    }

    public static void clearCaches() {
        cachedModels.clear();
    }
}

